cd "C:\Users\David\Dropbox\Documents\Work\Clients & prospects\GiveWell\Criminal justice\Replications"
set scheme s1color

* graph prisoners by month
use "C:\Users\David\Dropbox\Documents\Work\Library\Sentencing reform\Buonanno & Raphael 2013\prisonertimeseries2", clear
gen tm = ym(year, month)
tsset tm
format %tm tm
tsline prisoners, tline(`=tm(2006m8)+.5') yscale(range(0 .)) ylabel(0(10000)60000, angle(horizontal)) tlabel(2004m1(12)2009m1, format(%tmMonYY)) recast(scatter) xtitle("") ytitle("") plotregion(margin(zero)) graphregion(margin(0 5 0 3)) ///
	text(6000 `=tm(2006m8)+.5' "August 2006" "mass release", place(se))
graph export "Buonanno & Raphael prisoners.png", width(1000) replace

* smoothed crime plots by crime type
use "C:\Users\David\Dropbox\Documents\Work\Library\Sentencing reform\Buonanno & Raphael 2013\monthly_data_0408", clear
keep if inlist(crimeid, 1,2,3,7,8,12,13,16,17,18,19,20,25,26,27,39,40,50,51,52,55,56,57,58,59,61,62,63,64,69,74,75,76,77,78)

recode crimeid (1 2 3 7 8 12 13 16 17 18 19 = 1 "Violence, except sexual assault")  /// 
               (20 25 26                    = 2 "Sexual assault, corruption of a minor")  /// 
               (27 39                       = 3 "Theft, recieving stolen property")  /// 
               (40                          = 4 "Robbery")  /// 
			         (50 51 57                    = 5 "Extortion, usury, money laundering")  /// 
			         (52                          = 6 "Kidnapping")  /// 
			         (59                          = 7 "Arson")  /// 
			         (61 62                       = 8 "Vandalism, property damage")  /// 
			         (63 64                       = 9 "Contraband, drugs")  /// 
			         (69                          = 10 "Soliciting a prostitute") /// 
			         (55 56 58 74 75 76 77        = 11 "White-collar crime") ///
			         (78                          = 12 "Total reported crimes") ///
	, gen(crecode)

gen tm = ym(year, month)
collapse (first) year (sum) crime=crime_number (first) month, by(tm crecode)
xtset crecode tm
format tm %tm

recode year (2004 = 58462375) (2005 = 58751711) (2006 = 58691139) (2007 = 59175633) (2008 = 59832200), gen(pop)
gen crimepop = crime/pop*100000
tsline crimepop if crecode==12
sum crimepop if tm>=tm(2005m8) & tm<tm(2006m8) & crecode==12 // baseline monthly crime rate

merge m:1 year month using "C:\Users\David\Dropbox\Documents\Work\Library\Sentencing reform\Buonanno & Raphael 2013\prisonertimeseries2", keep(master match) nogen keepusing(ymonthrelative prisoners incrate)
ren ymonthrelative ymonthrel
gen byte post = ymonthrel > 0

levels crecode
foreach crime in `r(levels)' {
	local name = subinstr(subinstr(subinstr(substr("`:label crecode `crime''",1,28), " ", "_", .), ",", "", .), "-", "", .)
	local names `names' `name'
	local names_adj `names_adj' `name'_adj
	twoway lpolyci crimepop tm if tm>tm(2006m8), bwidth(3) degree(1) clcolor(black) || ///
	       lpolyci crimepop tm if tm<=tm(2006m8), bwidth(3) degree(1) clcolor(black) || ///
	       scatter crimepop tm, xline(`=tm(2006m8)+.5') legend(off) xlabel(`=tm(2004m1)'(12)`=tm(2008m1)', format(%tmMonYY)) mcolor(blue) || if crecode==`crime', ///
				 `=cond(`crime'<10,`"xlabel("")"', "")' xtitle("") ytitle("") ///
				 name(`name', replace) title("`:label crecode `crime''") ylabel(, angle(horizontal)) plotregion(margin(none)) graphregion(margin(none))
	regress crimepop i.month if crecode==`crime'
	predict crime_adj if e(sample), resid
	replace crime_adj = crime_adj + _b[_cons] if e(sample)
	twoway lpolyci crime_adj tm if tm >tm(2006m8), bwidth(3) degree(1) clcolor(black) || ///
			   lpolyci crime_adj tm if tm<=tm(2006m8), bwidth(3) degree(1) clcolor(black) ||  ///
			   scatter crime_adj tm, xline(`=tm(2006m8)+.5') legend(off) xlabel(`=tm(2004m1)'(12)`=tm(2008m1)', format(%tmMonYY)) mcolor(blue) || if crecode==`crime', ///
				 `=cond(`crime'<10,`"xlabel("")"', "")' xtitle("") ytitle("") ///
			   name(`name'_adj, replace) title("`:label crecode `crime''") ylabel(, angle(horizontal)) plotregion(margin(none)) graphregion(margin(none))
	drop crime_adj
}
graph combine `names', cols(3) xcommon name(all, replace) graphregion(margin(none)) imargin(0 0 0 0)
graph export "Buonanno & Raphael all.png", width(1000) replace
graph combine `names_adj', cols(3) xcommon name(all_adj, replace) graphregion(margin(none)) imargin(0 0 0 0)
graph export "Buonanno & Raphael all SA.png", width(1000) replace

** replication of Table 3 but doesn't assume errors in crime and incarceration eqs uncorrelated
constraint 1 [crimepop]u1 = 1
constraint 2 [incrate]u2  = 1
outreg, clear(Results)
forvalues m = 1/4 {
	local controls: word `m' of "" i.month "i.month i(2004/2007).year" "i.month i(2004/2007).year"

	if `m' < 4 {
		sureg  (crimepop c.ymonthrel##c.ymonthrel##post `controls') ///
	         (incrate  c.ymonthrel##c.ymonthrel##post `controls') if crecode==12, small isure
		est store est
		ivregress 2sls crimepop (incrate=post) c.ymonthrel##c.ymonthrel#post `controls' if crecode==12, small
		nlcom _b[incrate] * -12, post
	}
	else {
		sspace (crimepop c.ymonthrel##c.ymonthrel##post `controls' u1, noerror) /// // bivariate AR(1) model with cross-correlated errors
	         (incrate  c.ymonthrel##c.ymonthrel##post `controls' u2, noerror) ///
		       (u1 L.u1, state nocons) (u2 L.u2, state nocons)      if crecode==12, constr(1 2) covstate(unstr)
		est store est
		nlcom [crimepop]1.post / [incrate]1.post *-12, post
	}
	outreg, noautosumm se starlev(10 5 1) starloc(1) rtitle("Model (`m')") ctitle("", "Series break")

	foreach T in 6 12 18 24 {
		est restore est
		nlcom ([crimepop]ymonthrel + [crimepop]1.post#c.ymonthrel + ([crimepop]c.ymonthrel#c.ymonthrel+ [crimepop]c.ymonthrel#c.ymonthrel#1.post) * (2*`T'+1)) / ///
					( [incrate]ymonthrel +  [incrate]1.post#c.ymonthrel + ( [incrate]c.ymonthrel#c.ymonthrel+  [incrate]c.ymonthrel#c.ymonthrel#1.post) * (2*`T'+1)) * -12, post
		outreg, merge noautosumm se starlev(10 5 1) starloc(1) rtitle("Model (`m')") ctitle("", "T = `T'")
	}
	outreg, replay(Results) store(Results) append
}
outreg using "Buonanno & Raphael Table 3", replay(Results) replace

outreg, clear(Results)
levels crecode
foreach crime in `r(levels)' {
	sspace (incrate  c.ymonthrel##c.ymonthrel##post i.month i(2004/2007).year u1, noerror) /// // bivariate AR(1) model with cross-correlated errors
	       (crimepop c.ymonthrel##c.ymonthrel##post i.month i(2004/2007).year u2, noerror) ///
		     (u1 L.u1, state nocons) (u2 L.u2, state nocons) if crecode==`crime', constr(1 2) covstate(unstr)

	est store est
	outreg, clear
	foreach T in 6 12 18 24 {
		nlcom ( [crimepop]ymonthrel + [crimepop]1.post#c.ymonthrel + ([crimepop]c.ymonthrel#c.ymonthrel+ [crimepop]c.ymonthrel#c.ymonthrel#1.post) * (2*`T'+1)) / ///
					(  [incrate]ymonthrel +  [incrate]1.post#c.ymonthrel + ( [incrate]c.ymonthrel#c.ymonthrel+  [incrate]c.ymonthrel#c.ymonthrel#1.post) * (2*`T'+1)) * -12, post
		outreg, merge noautosumm se starlev(10 5 1) starloc(1) rtitle("`:label crecode `crime''")
		est restore est
	}
	outreg, replay(Results) store(Results) append
}
